<?php
/**
 * @package WordPress
 * @subpackage Classic_Theme
 */

automatic_feed_links();

if ( function_exists('register_sidebar') )
	register_sidebar(array(
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '',
		'after_title' => '',
	));


function bdw_get_images($iPostID, $return=false) {

	// Get the post ID
	// $iPostID = $post->ID;

	// Get images for this post
	$arrImages =& get_children('post_type=attachment&post_mime_type=image&post_parent=' . $iPostID );

	// If images exist for this page
	if($arrImages) {
		// Get array keys representing attached image numbers
		$arrKeys = array_keys($arrImages);
		// Get the first image attachment
		$iNum = $arrKeys[0];
		// Get the thumbnail url for the attachment
		$sThumbUrl = wp_get_attachment_url($iNum);

		// UNCOMMENT THIS IF YOU WANT THE FULL SIZE IMAGE INSTEAD OF THE THUMBNAIL
		//$sImageUrl = wp_get_attachment_url($iNum);

		// Build the <img> string
		if($return) { 
			$sImgString = '<a class="product-tiny-img" href="' . get_permalink() . '">' .
								'<img src="' . $sThumbUrl . '"  alt=" " />' .
							'</a>';

			// Print the image
			echo $sImgString;
		} else {
			$sImgString = $sThumbUrl;
			// Print the image
			echo $sImgString;
		
		}
	}
}


function bdw_get_pdf($iPostID, $return=false) {

	// Get the post ID
	// $iPostID = $post->ID;

	// Get images for this post
	$arrImages =& get_children('post_type=attachment&post_mime_type=application&post_parent=' . $iPostID );

	// If images exist for this page
	if($arrImages) {
		// Get array keys representing attached image numbers
		$arrKeys = array_keys($arrImages);
		// Get the first image attachment
		$iNum = $arrKeys[0];
		// Get the thumbnail url for the attachment
		$sThumbUrl = wp_get_attachment_url($iNum);

		// UNCOMMENT THIS IF YOU WANT THE FULL SIZE IMAGE INSTEAD OF THE THUMBNAIL
		//$sImageUrl = wp_get_attachment_url($iNum);

		// Build the <img> string
		if($return) { 
			$sImgString = '<a class="product-tiny-img" href="' . get_permalink() . '">' .
								'<img src="' . $sThumbUrl . '"  alt=" " />' .
							'</a>';

			// Print the image
			echo $sImgString;
		} else {
			$sImgString = $sThumbUrl;
			// Print the image
			echo $sImgString;
		
		}
	}
}

remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');

function remove_generator() {
	return '';
}

add_filter('the_generator', 'remove_generator');
?>
