<?php
/**
 * @package WordPress
 * @subpackage Classic_Theme
 */
get_header();
?>


<div class="widecolumn clearfix">
	<h1><a href="<?php the_permalink() ?>"><?php single_cat_title(); ?></a></h1>
	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
	<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
		<span class="a-right"><?php edit_post_link(__('Edit This')); ?></span>
		<?php if(is_category()) { ?>
			<h2 class="category-item"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h2>
		<?php } elseif (is_single()) { ?>
			<h1>Stiri</h1>
			<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
		<?php } else { ?>
			<h1><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h1>
		<?php } ?>
		<div class="storycontent">
			<?php the_content(__('&raquo; more...')); ?>
		</div>
	</div>
	<?php if($post->ID == '15') { /* news category*/ ?>
	<?php
		//The Query
		$cat_id = '1'; // news
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		query_posts("cat=$cat_id&posts_per_page=5&paged=$paged");
		global $more;
		//The Loop
		$i = 0;
		if ( have_posts() ) : while ( have_posts() ) : the_post();
			$more = 0;
		?>
		<div class="news-item clearfix">
			<h3><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></h3>
			<?php the_content(__('<br />citeste intregul articol ►')); ?>
		</div>
		<?php endwhile; ?>
		<div class="navigation">
			<div class="a-right"><h4><?php previous_posts_link('Articole mai noi ►') ?></h4></div>
			<div class="a-left"><h4><?php next_posts_link('◄ Articole mai vechi') ?></h4></div>
		</div>
		<?php else:
			echo 'nada';
		endif;
		//Reset Query
		wp_reset_query();
	?>
	<?php } ?>
	<?php //comments_template(); // Get wp-comments.php template ?>

	<?php endwhile; else: ?>
	<p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
	<?php endif; ?>

	<?php posts_nav_link(' &#8212; ', __('&laquo; Newer Posts'), __('Older Posts &raquo;')); ?>
</div>

</div>
<?php get_footer(); ?>